/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * QueWeb software product meta information.
 * @author Sultan Tezadov
 * @since 9 Mar 2007
 */
public class ProductMeta implements IsSerializable {
    private String name;
    private String version;
    
    public ProductMeta() {
        this("", "");
    }

    public ProductMeta(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getNameAndVersion() {
        return name + " " + version;
    }
    
}
