/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 *
 * @author Alexander Epifanov, Vasily Mikhailitchenko
 */
public class SavedSearchObject implements IsSerializable {
    private String searchName;
    private String formId;
    private FieldData[] fieldsData;
    private Long rowID;

    /**
     * Creates a new instance of SavedSearchObject
     */
    public SavedSearchObject() {
    }

    public SavedSearchObject(String searchName, String formId, FieldData[] fieldsData, Long rowID) {
        this.searchName = searchName;
        this.formId = formId;
        this.fieldsData = fieldsData;
        this.rowID = rowID;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public FieldData[] getFieldsData() {
        return this.fieldsData;
    }    

    public void setFieldsData(FieldData[] fieldsData) {
        this.fieldsData = fieldsData;
    }

    public Long getRowID() {
        return this.rowID;
    }

    public void setRowID(Long rowID) {
        this.rowID = rowID;
    }

    public boolean isRowIDSet(){
        return (rowID != null);
    }
}

