/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Represents SubFocus metadata
 * @author Sergey Kozmin
 * @since 13 Oct 2006
 */
public class SubFocusMeta implements IsSerializable {
    public static class Index extends FocusMeta.Index {
        public int subFocus;
        
        public int getType() {
            return SUBFOCUS;
        }
        
        public void init(FocusMeta.Index focusIndex, int subFocusIndex) {
            this.focus = focusIndex.focus;
            this.subFocus = subFocusIndex;
        }
    }
    
    private Index index;
    private String caption;
    private String subFocusName;
    private String icon;
    private TabMeta[] tabs;

    public SubFocusMeta(String caption, String subFocusName, TabMeta[] tabs) {
        this.index = new Index();
        this.caption = caption;
        this.subFocusName = subFocusName;
        if(tabs != null) {
            this.tabs = tabs;
        } else {
            this.tabs = new TabMeta[0];
        }
    }

    public SubFocusMeta(String caption, String icon, String subFocusName, TabMeta[] tabs) {
        this(caption, subFocusName, tabs);
        this.icon = icon;
    }

    public SubFocusMeta() {
        this("", "", null);
    }

    void initIndexes(FocusMeta.Index focusIndex, int subFocusIndex) {
        index.init(focusIndex, subFocusIndex);
        initChildrenIndexes();
    }

    private void initChildrenIndexes() {
        for (int i = 0; i < tabs.length; i++) {
            tabs[i].initIndexes(index, i);
        }
    }

    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public TabMeta[] getTabs() {
        return tabs;
    }

    public void setTabs(TabMeta[] tabs) {
        if(tabs != null) {
            this.tabs = tabs;
            initChildrenIndexes();
        }
    }

    public String getSubFocusName() {
        return subFocusName;
    }

    public Index getIndex() {
        return index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public FamgMeta getFamgMeta(FamgMeta.Index index) {
        return tabs[index.tab].getFamgMeta(index);
    }

    public TabMeta getTabMeta(TabMeta.Index index) {
        return tabs[index.tab];
    }

    public TabMeta getTabMeta(String tabName) {
        TabMeta tabMeta = null;
        for (int i = 0; i < tabs.length; i++) {
            if(tabs[i].getTabName().equalsIgnoreCase(tabName)) {
                tabMeta = tabs[i];
                break;
            }
        }
        return tabMeta;
    }

    public FamgMeta.Index getFormIndex(String tabName, String entityName) {
        FamgMeta.Index index = null;
        for (int i = 0; i < tabs.length; i++) {
            if(tabs[i].getTabName().equalsIgnoreCase(tabName)) {
                index = tabs[i].getFormIndex(entityName);
                break;
            }
        }
        return index;
    }

    public TabMeta.Index getTabIndex(String tabName) {
        TabMeta tabMeta = getTabMeta(tabName);
        return (tabMeta != null) ? tabMeta.getIndex() : null;
    }

    public String getFormID(FamgMeta.Index index) {
        return tabs[index.tab].getFormID(index);
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

}
