/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Subset Meta
 * @author Sultan Tezadov
 */
public class SubsetMeta implements IsSerializable {
    private SubsetItemMeta[] items;
    
    public SubsetMeta() {
        this(new SubsetItemMeta[0]);
    }

    public SubsetMeta(SubsetItemMeta[] items) {
        setItems(items);
    }

    public SubsetItemMeta[] getItems() {
        return items;
    }

    public void setItems(SubsetItemMeta[] items) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 'items' can not be null");
        }
        this.items = items;
    }
    
    public SubsetItemMeta getItemByID(long id) {
        for (int i = 0; i < items.length; i++) {
            if (items[i].getId() == id) {
                return items[i];
            }
        }
        return null;
    }

    public boolean equalsToMeta(SubsetMeta obj) {
        boolean ret = false;
        if(items == null) {
            ret = obj.items == null;
        } else {
            if(obj.items != null) {
                if(obj.items.length == items.length) {
                    boolean allEqual = true;
                    for (int i = 0; i < items.length; i++) {
                        if(!obj.items[i].equals(items[i])) {
                            allEqual = false;
                            break;
                        }
                    }
                    if(allEqual) {
                        ret = true;
                    }
                }
            }
        }
        return ret;
    }
}
