/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

/**
 * MetaData container for textbox field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public class TextBoxFieldMeta extends BaseFieldMeta {
    private String pattern;
    private boolean masked;
    
    public TextBoxFieldMeta(String fieldID, String caption, String pattern, boolean masked) {
        this(fieldID, caption, pattern);
        this.setMasked(masked);
    }

    public TextBoxFieldMeta(String fieldID, String caption, String pattern) {
        this(fieldID, caption);
        this.setPattern(pattern);
    }

    public TextBoxFieldMeta(String fieldID, String caption) {
        super(TEXTBOX, fieldID, caption);
    }

    public TextBoxFieldMeta(String fieldID) {
        this(fieldID, "");
    }

    public TextBoxFieldMeta() {
        this("");
    }
    
    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isMasked() {
        return masked;
    }

    public void setMasked(boolean masked) {
        this.masked = masked;
    }

}
