/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

import com.queplix.core.client.common.StringUtil;

/**
 * Data container for textbox field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public class TextboxFieldData extends BaseFieldData {
    private String text;

    public TextboxFieldData(String fieldID, String text) {
        super(fieldID);
        this.text = text;
    }

    public TextboxFieldData() {
        this("", "");
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void clear() {
        text = "";
    }

    public boolean isEmpty() {
        return text == null || "".equalsIgnoreCase(text.trim());
    }

    public FieldData cloneData() {
        return new TextboxFieldData(getFieldID(), text);
    }

    public boolean dataEqualsTo(FieldData data) {
        boolean ret = false;
        if(data != null && data.getFieldID().equalsIgnoreCase(getFieldID())) {
            //assume that if ids are equal, then control types are equal too (within one form)
            TextboxFieldData castData = (TextboxFieldData) data;

            ret = StringUtil.isStringsEqualsIgnoreNulls(castData.text, text);
        }
        return ret;
    }
}
