/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo.chart;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Container for the data that is necessary to draw the chart.
 * @author Michael Trofimov
 */
public class ChartResponseObject implements IsSerializable {

    private ChartMeta meta;
    private ChartData data;

    public ChartResponseObject(){
    }

    /**
     * "Main" way to create <code>ChartResponseObject</code> instance. 
     * @throws IllegalArgumentException in case if data is null
     */
    public ChartResponseObject(ChartData data){
    	if (data == null)
    		throw new IllegalArgumentException("data can't be a null");

        this.data = data;
    }

    /**
     * This constructor is designated to use only in the special case - when
     * we need to retrieve everything about chart as the result of a single RPC call.
     */
    public ChartResponseObject(ChartMeta meta, ChartData data){
    	this(data);

    	if (meta == null)
    		throw new IllegalArgumentException("meta can't be a null");

        this.meta = meta;
    }

    /**
     * Returns chart's metadata.
     */
    public ChartMeta getMeta(){
        return meta;
    }

    /**
     * Returns chart's data.
     */
    public ChartData getData(){
        return data;
    }

}
