/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo.util;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Date;

/**
 * Invariant date -- represents a datestamp without timezone information.
 * Used for inter-timezone calculations.
 * @author Sultan Tezadov
 * @since 13 Feb 2007
 */
public class InvariantDate implements IsSerializable {
    private int year;
    private int month;
    private int date;
    private int hours;
    private int minutes;
    private int seconds;
    
    public InvariantDate() {
    }
    
    public InvariantDate(int year, int month, int date, int hours, int minutes, int seconds) {
        this.year = year;
        this.month = month;
        this.date = date;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }
    
    private InvariantDate(Date date) {
        this(date.getYear(), date.getMonth(), date.getDate(), 
                date.getHours(), date.getMinutes(), date.getSeconds());
    }
    
    public static InvariantDate fromDate(Date date) {
        return (date != null) ? new InvariantDate(date) : null;
    }
    
    public static Date toDate(InvariantDate invDate) {
        return (invDate != null) ? invDate.toDate() : null;
    }
    
    private Date toDate() {
        return new Date(year, month, date, hours, minutes, seconds);
    }

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDate() {
        return date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public int getHours() {
        return hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getMinutes() {
        return minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getSeconds() {
        return seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public boolean equals(Object obj) {
        if(obj == null || !(obj instanceof InvariantDate)) {
            return false;
        }
        InvariantDate castDate = (InvariantDate) obj;
        return castDate.year     == year    &&
               castDate.month    == month   &&
               castDate.date     == date    &&
               castDate.hours    == hours   &&
               castDate.minutes  == minutes &&
               castDate.seconds  == seconds;
    }

    public static boolean isInvariantDatesEqual(InvariantDate d1, InvariantDate d2) {
        if(d1 == null) {
            return d2 == null;
        } else {
            return d1.equals(d2);
        }
    }
}
