<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright 2006-2007 Queplix Corp.
  ~
  ~ Licensed under the Queplix Public License, Version 1.1.1 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
  ~ License for the specific language governing permissions and limitations under
  ~ the License.
  -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>

	<!-- Global variables {{{ -->
	<!-- if exists, then the report is for export to word and excel -->
	<xsl:param name="EXPORTED_REPORT"/>

	<!-- Report header/footer -->
	<xsl:variable name="processId" select="/report/@processId"/>
	<xsl:variable name="reportHeader" select="//report-header"/>
	<xsl:variable name="reportFooter" select="//report-footer"/>
	<xsl:variable name="pageHeader" select="//page-header"/>
	<xsl:variable name="pageFooter" select="//page-footer"/>

	<!-- Header row -->
	<xsl:variable name="headerFontName">
		<xsl:choose>
			<xsl:when test="//headerFontName"><xsl:value-of select="//headerFontName"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Arial'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerFontSize">
		<xsl:choose>
			<xsl:when test="//headerFontSize"><xsl:value-of select="//headerFontSize"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'12'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerForeColor">
		<xsl:choose>
			<xsl:when test="//headerForeColor"><xsl:value-of select="//headerForeColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Black'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerBackColor">
		<xsl:choose>
			<xsl:when test="//headerBackColor"><xsl:value-of select="//headerBackColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'#ADAA9C'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerBold" select="//headerBold/text() = 'true'"/>
	<xsl:variable name="headerItalic" select="//headerItalic/text() = 'true'"/>
	
	<!-- Even row -->
	<xsl:variable name="evenFontName">
		<xsl:choose>
			<xsl:when test="//evenFontName"><xsl:value-of select="//evenFontName"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Arial'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="evenFontSize">
		<xsl:choose>
			<xsl:when test="//evenFontSize"><xsl:value-of select="//evenFontSize"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'12'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="evenForeColor">
		<xsl:choose>
			<xsl:when test="//evenForeColor"><xsl:value-of select="//evenForeColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Black'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="evenBackColor">
		<xsl:choose>
			<xsl:when test="//evenBackColor"><xsl:value-of select="//evenBackColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'White'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="evenBold" select="//evenBold/text() = 'true'"/>
	<xsl:variable name="evenItalic" select="//evenItalic/text() = 'true'"/>

	<!-- Odd row -->
	<xsl:variable name="oddFontName">
		<xsl:choose>
			<xsl:when test="//oddFontName"><xsl:value-of select="//oddFontName"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Arial'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="oddFontSize">
		<xsl:choose>
			<xsl:when test="//oddFontSize"><xsl:value-of select="//oddFontSize"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'12'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="oddForeColor">
		<xsl:choose>
			<xsl:when test="//oddForeColor"><xsl:value-of select="//oddForeColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Black'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="oddBackColor">
		<xsl:choose>
			<xsl:when test="//oddBackColor"><xsl:value-of select="//oddBackColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'#FFFFDD'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="oddBold" select="//oddBold/text() = 'true'"/>
	<xsl:variable name="oddItalic" select="//oddItalic/text() = 'true'"/>

	<!-- Page variables -->
	<xsl:variable name="makeHeader" select="/report/reportiter/@isFirst = 'true'"/>
	<xsl:variable name="makeFooter" select="/report/reportiter/@isLast = 'true'"/>

	<!-- Find group column -->
	<xsl:variable name="group" select="boolean(//req-field[@group = 'true'])"/>

	<!-- Global variables }}} -->

	<xsl:template match="report">
		<xsl:apply-templates select="reportiter/ress"/>
	</xsl:template>

	<xsl:template match="ress">
		<xsl:if test="$makeHeader">
			<xsl:variable name="hasReportHeader" select="not(string-length($reportHeader) = 0)"/>
			<xsl:variable name="hasPageHeader" select="not(string-length($pageHeader) = 0)"/>		

			<xsl:text disable-output-escaping="yes">&lt;html&gt;</xsl:text>
			<head>
					<xsl:if test="not($EXPORTED_REPORT)">
						<link rel="stylesheet" href="/style/main.css" type="text/css"/>
						<script src="/js/modules/focus/print/gridpopup.js">1</script>
						<script>
							var processId = <xsl:text>'</xsl:text><xsl:value-of select="$processId"/><xsl:text>'</xsl:text>;
							var transletName = 'report';
						</script>
					</xsl:if>
					<style>
						<xsl:text disable-output-escaping="yes">
&lt;!--table
td
	{
	mso-number-format:"\@";
	}
--&gt;
						</xsl:text>
					</style>
			</head>
			<xsl:text disable-output-escaping="yes">&lt;body leftmargin="5" topmargin="5" marginheight="5" marginwidth="5" 
			oncontextmenu="showGridMenu(); return false" style="background-color:#FFFFFF"&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;span&gt;</xsl:text>		
			<xsl:if test="$hasReportHeader or $hasPageHeader">
				<table border="0" style="width:100%">
					<xsl:if test="$hasReportHeader">
						<tr>
							<td class="label" style="white-space:nowrap;font-weight:bold"><xsl:value-of select="$reportHeader"/></td>
						</tr>
					</xsl:if>
					<xsl:if test="$hasPageHeader">
						<tr>
							<td class="label" style="white-space:nowrap;font-weight:bold"><xsl:value-of select="$pageHeader"/></td>
						</tr>
					</xsl:if>
				</table>
				<p/>			
			</xsl:if>

			<xsl:text disable-output-escaping="yes">&lt;table border="0" cellspacing="1" class="gridTable" id="reportGrid"&gt;</xsl:text>
			<xsl:apply-templates select="res-header"/>
		</xsl:if>
		
		<xsl:apply-templates select="res"/>

		<xsl:if test="$makeFooter">
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<p/>

			<table border="0" style="width:100%">
				<xsl:if test="not(string-length($pageFooter) = 0)">
					<tr>
						<td class="label" style="white-space:nowrap;font-weight:bold"><xsl:value-of select="$pageFooter"/></td>
					</tr>
				</xsl:if>
				<xsl:if test="not(string-length($reportFooter) = 0)">
					<tr>
						<td class="label" style="white-space:nowrap;font-weight:bold"><xsl:value-of select="$reportFooter"/></td>
					</tr>
				</xsl:if>
			</table>

			<div id="ordermenu" style="width:100; overflow:visible; position:absolute; visibility:hidden; z-index:100" onMouseOut="outGridMenu()" onMouseOver="overGridMenu()"></div>
			<xsl:text disable-output-escaping="yes">&lt;/span&gt;&lt;/body&gt;&lt;/html&gt;</xsl:text>
		</xsl:if>
		
	</xsl:template>

	<xsl:template match="res-header">
		<tr>
			<xsl:attribute name="style">
				<xsl:value-of select="concat('font-family:', $headerFontName, '; font-size:', $headerFontSize, 'px; color:', $headerForeColor,'; background-color:', $headerBackColor,';font-weight:')"/>
				<xsl:choose>
					<xsl:when test="$headerBold">
						<xsl:text>bold</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>none</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text>;font-style:</xsl:text>
				<xsl:choose>
					<xsl:when test="$headerItalic">
						<xsl:text>italic</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>none</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates select="res-header-field"/>
		</tr>
	</xsl:template>

	<xsl:template match="res-header-field">
		<td>
			<xsl:attribute name="id">
				<xsl:text>tab.</xsl:text>
				<xsl:value-of select="@entity"/>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<div>
				<xsl:attribute name="style">
					<xsl:text>cursor:pointer; cursor:hand; white-space:nowrap;</xsl:text>
					<xsl:call-template name="columnSize">
						<xsl:with-param name="name" select="@name"/>
						<xsl:with-param name="entity" select="@entity"/>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:apply-templates select="/report/reqs/req/req-field">
					<xsl:with-param name="sortentity" select="@entity"/>
					<xsl:with-param name="sortname" select="@name"/>
				</xsl:apply-templates>
				<xsl:choose>
					<xsl:when test="@caption">
						<xsl:value-of select="@caption"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat(@entity, '__', @name)"/>
					</xsl:otherwise>
				</xsl:choose>
			</div>
		</td>
	</xsl:template>

	<xsl:template match="req-field">
		<xsl:param name="sortentity"/>
		<xsl:param name="sortname"/>
		<xsl:for-each select=".">
			<xsl:if test="@entity = $sortentity and @name = $sortname">
				<!-- Sort ascending. -->
				<xsl:if test="@sort = 'true' and @sortdir = 'asc'">[A] </xsl:if>
				<!-- Sort descending. -->
				<xsl:if test="@sort = 'true' and @sortdir = 'desc'">[D] </xsl:if>
				<!-- Group by. -->
				<xsl:if test="@group = 'true'">[G] </xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="res">
		<xsl:apply-templates select="res-record"/>
	</xsl:template>

	<xsl:template match="res-record">
		<tr id="{@id}" style="background-color:white; color:black; font-family:Arial; font-size:12px;">
			<xsl:attribute name="style">
				<xsl:text>cursor:pointer; cursor:hand;</xsl:text>
				<xsl:choose>
					<xsl:when test="number(@id) mod 2">
						<xsl:value-of select="concat('background-color:', $oddBackColor, ';color:', $oddForeColor, ';font-family:', $oddFontName,';font-size:', $oddFontSize, ';font-weight:')"/>
						<xsl:choose>
							<xsl:when test="$oddBold">
								<xsl:text>bold</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>;font-style:</xsl:text>
						<xsl:choose>
							<xsl:when test="$oddItalic">
								<xsl:text>italic</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('background-color:', $evenBackColor, ';color:', $evenForeColor, ';font-family:', $evenFontName,';font-size:', $evenFontSize, ';font-weight:')"/>
						<xsl:choose>
							<xsl:when test="$evenBold">
								<xsl:text>bold</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>;font-style:</xsl:text>
						<xsl:choose>
							<xsl:when test="$evenItalic">
								<xsl:text>italic</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates select="res-field"/>
		</tr>
	</xsl:template>
	
	<xsl:template match="res-field">
		<xsl:if test="not($group) or (not(res-field-value) and not(res-field-text)) or res-field-value/text() or res-field-text/text()">
			<td valign="top">
				<xsl:if test="@recordspan">
					<xsl:attribute name="rowspan"><xsl:value-of select="@recordspan + 1"/></xsl:attribute>
				</xsl:if>
				<div>
					<xsl:attribute name="style">
						<xsl:text>white-space:nowrap;</xsl:text>
						<xsl:call-template name="columnSize">
							<xsl:with-param name="name" select="@name"/>
							<xsl:with-param name="entity" select="@entity"/>
						</xsl:call-template>
					</xsl:attribute>
					<xsl:choose>
						<xsl:when test="res-field-text">
							<xsl:value-of select="res-field-text/text()"/>
						</xsl:when>
						<xsl:when test="res-field-value">
							<xsl:value-of  select="res-field-value/text()"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>&#160;</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>
		</xsl:if>
	</xsl:template>

	<xsl:template name="columnSize">
		<xsl:param name="name"/>
		<xsl:param name="entity"/>
		<xsl:variable name="size" select="/report/reqs/req/req-field[@name = $name and @entity = $entity]/@size"/>
		<xsl:if test="$size">
			<xsl:value-of select="concat(' overflow:hidden; width:', $size, 'px')"/>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
