/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator.security;

import com.queplix.core.utils.SystemHelper;

/**
 * Country VO object.
 *
 * @author Kozmin Sergey
 * @since 16.01.2007
 */

public class Country {
    // Primary data
    private String id;
    private String name;

    // Additional data.
    private String defLangID;
    private String defTzID;

    public Country(String id, String name, String defLangID, String defTzID) {
        this.id = id;
        this.name = name;
        this.defLangID = defLangID;
        this.defTzID = defTzID;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefLangID() {
        return defLangID;
    }

    public void setDefLangID(String defLangID) {
        this.defLangID = defLangID;
    }

    public String getDefTzID() {
        return defTzID;
    }

    public void setDefTzID(String defTzID) {
        this.defTzID = defTzID;
    }

    public static String getDefault() {
        return SystemHelper.DEFAULT_COUNTRY;
    }
}
