/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator.security;

import com.queplix.core.utils.SystemHelper;

/**
 * Language VO class.
 *
 * @author Kozmin Sergey
 * @since 16.01.2007
 */

public class Language {

    private String id;
    private String name;


    public Language(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }/*
     * No javadoc
     * @see Object#equals
     */

    public boolean equals(Object obj) {
        return obj == this || (obj instanceof Language) && (((Language) obj).getId().equals(id));

    }

    public int hashCode() {
        return id.hashCode();
    }

    public String toString() {
        return name;
    }

    public static String getDefault() {
        return SystemHelper.DEFAULT_LANGUAGE;
    }
}
