/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator.security;

import com.queplix.core.utils.SystemHelper;

import java.util.TimeZone;

/**
 * Time zone VO class.
 *
 * @author Kozmin Sergey
 * @since 16.01.2007
 */

public class Timezone {
    private String id;
    private String name;
    private String shortDisplayName;
    private String longDisplayName;

    public Timezone(String _id, String _name) {
        id = _id;
        name = _name;

        TimeZone javaTz;
        javaTz = TimeZone.getTimeZone(id);
        if(javaTz != null) {
            shortDisplayName = javaTz.getDisplayName(false, TimeZone.SHORT);
            longDisplayName = javaTz.getDisplayName(false, TimeZone.LONG);
        } else {
            shortDisplayName = "";
            longDisplayName = "";
        }
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getShortDisplayName() {
        return shortDisplayName;
    }

    public String getLongDisplayName() {
        return longDisplayName;
    }

    public boolean equals(Object obj) {
        return obj == this || (obj instanceof Timezone) && (((Timezone) obj).getId().equals(id));
    }

    public int hashCode() {
        return id.hashCode();
    }

    public String toString() {
        return name;
    }

    public static String getDefault() {
        return SystemHelper.DEFAULT_TIMEZONE.getID();
    }
}
