/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.alert.ejb;

import com.queplix.core.modules.alert.AlertData;
import com.queplix.core.modules.alert.utils.AlertSelectorCriteria;

import javax.ejb.EJBLocalObject;
import java.util.Date;
import java.util.SortedMap;

/**
 * Alert manager local interface.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:07 $
 */

public interface AlertManagerLocal
    extends EJBLocalObject {

    void setId( long alertID );
    void setCreator( long creatorID, int creatorType );
    void setSender( long senderID, int senderType );
    void setDateposted( Date dateposted );
    void setData( AlertData data );

    long[] sendAlert();
    long[] sendAlert( long recipientID, int recipientType );
    long[] sendAlerts( long workgroupID, Integer tier, boolean toAll );

    long[] updateAlert();

    long[] deleteAlerts();

    SortedMap getAlerts( AlertSelectorCriteria criteria );

} // end of interface
