/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.alert.utils;

import com.queplix.core.integrator.security.LogonSession;

import java.io.Serializable;

/**
 * Alert selector search criteria.
 * @see AlertSelector
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:08 $
 */

public class AlertSelectorCriteria
    implements Serializable {

    // ----------------------------------------------------- variables

    // in variables...

    private LogonSession ls = null;

    private boolean incomming = true;

    private Long startID;
    private Integer page;
    private Integer pageSize;

    // out variables...

    private boolean availableMore;

    // ----------------------------------------------------- public methods

    public void setLogonSession( LogonSession ls ) {
        this.ls = ls;
    }

    public LogonSession getLogonSession() {
        return ls;
    }

    public void setStartID( Long startID ) {
        this.startID = startID;
    }

    public Long getStartID() {
        return startID;
    }

    public void setPage( Integer page ) {
        this.page = page;
    }

    public Integer getPage() {
        return page;
    }

    public void setPageSize( Integer pageSize ) {
        this.pageSize = pageSize;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setIncomming( boolean incomming ) {
        this.incomming = incomming;
    }

    public boolean isIncomming() {
        return incomming;
    }

    public void setAvailableMore( boolean availableMore ) {
        this.availableMore = availableMore;
    }

    public boolean isAvailableMore() {
        return availableMore;
    }

    /*
     * No javadoc
     * @see Object#toString
     */
    public String toString() {
        return "start id=" + startID +
            "; page=" + page +
            "; page size=" + pageSize +
            "; incomming=" + incomming;
    }
}
