/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.attachment.ejb;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.jeo.gen.AttachmentObject;
import com.queplix.core.modules.jeo.gen.AttachmentTempObject;

import java.util.HashMap;

/**
 * Attachement manager EJB local interface.
 *
 * @author [ALB] Baranov Andrey
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.2 $ $Date: 2006/01/26 15:00:53 $
 */
public interface AttachmentManagerLocal
    extends javax.ejb.EJBLocalObject {

    long getUniqueProcessID();

    long addTempAttachment( LogonSession ls,
                            long processID,
                            String fileName,
                            String fileType,
                            byte[] data,
                            boolean purge );

    long addTempAttachment( LogonSession ls,
                            long processID,
                            String fileName,
                            String fileType,
                            byte[] data );

    AttachmentTempObject[] copyAttachmentsToTemp( LogonSession ls,
                                                  long processID,
                                                  long tempProcessID );

    AttachmentTempObject getTempAttachment( LogonSession ls, long tempAttachID );

    AttachmentTempObject[] getTempAttachments( LogonSession ls, long processID );

    void deleteTempAttachment( LogonSession ls, long tempAttachID );

    void deleteTempAttachments( LogonSession ls, long[] tempAttachIDs );

    void deleteTempAttachments( LogonSession ls, long processID );

    long addAttachment( LogonSession ls, long tempAttachID );

    HashMap addAttachments( LogonSession ls, long processID );

    AttachmentObject getAttachment( LogonSession ls, long attachID );
    AttachmentObject getAttachment( LogonSession ls, long processID, String filename );

    AttachmentObject[] getAttachments( LogonSession ls, long processID );

    void deleteAttachment( LogonSession ls, long attachID );

    void deleteAttachments( LogonSession ls, long processID );
}
