/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.ejb;

import com.queplix.core.modules.config.jxb.Captions;
import com.queplix.core.modules.config.utils.CaptionConstants;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.ejb.AbstractSessionEJB;

/**
 * Facade session EJB for Caption management
 * @author [SVM] Maxim Suponya
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:14 $
 */
@Deprecated
public class CaptionManagerEJB
    extends AbstractSessionEJB
    implements CaptionConstants {

    //---------------------------------------------------------------- public methods

    public void ejbCreate() {}

    /**
     * Fill Efield captions
     * @param entityName Entity name attribute
     * @param efieldName Efield name attribute
     * @param captions Captions object
     * @return id of Captions object
     */
    public String fillEfieldCaptions( String entityName, String efieldName, Captions captions ) {
        return getLocalizationManagerLocal().fillEfieldCaptions(entityName, efieldName, captions);
    }

    /**
     * Fill Focus captions
     * @param focusId focus id attribute
     * @param captions Captions object
     * @return id of Captions object
     */
    public String fillFocusCaptions( String focusId, Captions captions ) {
        return getLocalizationManagerLocal().fillFocusCaptions(focusId, captions);
    }

    /**
     * Fill SubFocus captions
     * @param subFocusId subfocus id attribute
     * @param captions Captions object
     * @return id of Captions object
     */
    public String fillSubFocusCaptions( String subFocusId, Captions captions ) {
        return getLocalizationManagerLocal().fillSubFocusCaptions(subFocusId, captions);
    }

    /**
     * Fill Tab captions
     * @param tabId tab id attribute
     * @param captions Captions object
     * @return id of Captions object
     */
    public String fillTabCaptions( String tabId, Captions captions ) {
        return getLocalizationManagerLocal().fillTabCaptions(tabId, captions);
    }

    /**
     * Fill Form captions
     * @param formId form id attribute
     * @param captions Captions object
     * @return id of Captions object
     */
    public String fillFormCaptions( String formId, Captions captions ) {
        return getLocalizationManagerLocal().fillFormCaptions(formId, captions);
    }
    
    /**
     * Fill Button captions
     * @param buttonId button id attribute
     * @param captions Captions object
     * @return id of Captions object
     */
    public String fillButtonCaptions( String buttonId, Captions captions) {
        return getLocalizationManagerLocal().fillButtonCaptions(buttonId, captions);
    }

    /**
     * Fill server messages
     * @param id message id
     * @param captions Captions object
     * @return id of Captions object
     */
    public String fillServerMessages( String id, Captions captions ) {
        return getLocalizationManagerLocal().fillServerMessages(id, captions);
    }

    /**
     * Fill PopupMenu captions
     * @param captionId id
     * @param captions Captions object
     * @return id of Captions object
     */
    public String fillPopupMenuCaptions( String captionId, Captions captions ) {
        return getLocalizationManagerLocal().fillPopupMenuCaptions(captionId, captions);
    }

    /**
     * Fill MenuItem captions
     * @param menuId id
     * @param captions Captions object
     * @return id of Captions object
     */
    public String fillMenuItemCaptions( String menuId, Captions captions ) {
        return getLocalizationManagerLocal().fillMenuItemCaptions(menuId, captions);
    }

    /**
     * Get Efield caption
     * @param languageId language id
     * @param entityName Entity name attribute
     * @param efieldName Efield name attribute
     * @return localized Caption
     */
    public String getEfieldCaption( String languageId, String entityName, String efieldName ) {
        return getLocalizationManagerLocal().getEfieldCaption(languageId, entityName, efieldName);
    }

    /**
     * Get Focus caption
     * @param languageId language id
     * @param focusId focus id attribute
     * @return localized Caption
     */
    public String getFocusCaption( String languageId, String focusId ) {
        return getLocalizationManagerLocal().getFocusCaption(languageId, focusId);
    }

    /**
     * Get SubFocus caption
     * @param languageId language id
     * @param subFocusId Subfocus id attribute
     * @return localized Caption
     */
    public String getSubFocusCaption( String languageId, String subFocusId ) {
        return getLocalizationManagerLocal().getSubFocusCaption(languageId, subFocusId);
    }

    /**
     * Get Tab caption
     * @param languageId language id
     * @param tabId tab id attribute
     * @return localized Caption
     */
    public String getTabCaption( String languageId, String tabId ) {
        return getLocalizationManagerLocal().getTabCaption(languageId, tabId);
    }

    /**
     * Get Form caption
     * @param languageId language id
     * @param formId form id attribute
     * @return localized Caption
     */
    public String getFormCaption( String languageId, String formId ) {
        return getLocalizationManagerLocal().getFormCaption(languageId, formId);
    }

    /**
     * Get Button caption
     * @param languageId language id
     * @param buttonId button id attribute
     * @return localized Caption
     */
    public String getButtonCaption( String languageId, String buttonId) {
        return getLocalizationManagerLocal().getButtonCaption(languageId, buttonId);
    }
    
    /**
     * Get Popup Menu caption
     * @param languageId language id
     * @param captionId id
     * @return localized Caption
     */
    public String getPopupMenuCaption( String languageId, String captionId ) {
        return getLocalizationManagerLocal().getPopupMenuCaption(languageId, captionId);
    }

    /**
     * Get server message
     * @param languageId language id
     * @param id message id
     * @return localized Caption
     */
    public String getServerMessage( String languageId, String id ) {
        return getLocalizationManagerLocal().getServerMessage(languageId, id);
    }

    /**
     * Get menu item captions
     * @param languageId language id
     * @param menuId menu item id
     * @return localized Caption
     */
    public String getMenuItemCaption( String languageId, String menuId ) {
        return getLocalizationManagerLocal().getMenuItemCaption(languageId, menuId);
    }

    
    //---------------------------------------------------------------- private methods

    private LocalizationManagerLocal getLocalizationManagerLocal() {
        return (LocalizationManagerLocal) getLocalObject(
                JNDINames.LocalizationManager, LocalizationManagerLocalHome.class);
    }
}
