/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.ejb;

import com.queplix.core.integrator.security.User;
import com.queplix.core.modules.config.utils.UserPropertyID;
import com.queplix.core.modules.config.utils.DialogSetting;
import com.queplix.core.modules.config.utils.GridSetting;

import javax.ejb.EJBLocalObject;
import java.util.Map;
import java.util.Collection;

/**
 * UserPropertyManager EJB local interface.
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:15 $
 */
public interface UserPropertyManagerLocal extends EJBLocalObject {
    public String getUserProperty(String propId, User user);
    public Map getAllUserProperties(User user);
    public UserPropertyID setUserProperty(String propId, String value, User user);
    public UserPropertyID deleteUserProperty(String propId, User user);

    public String[] getFieldsForGrid(User user, String entity);
    public UserPropertyID setFieldsForGrid(User user, String entity, String[] fields);

    public void deleteDialogUISettings(User user);
    public void updateDialogUISettings(User user, DialogSetting settingsToSave);
    public void resetDialogUISettings(User user, Collection<DialogSetting> settingsToSave);
    public Collection<DialogSetting> loadDialogsUISettings(User user);

    public void deleteGridSettings(User user);
    public void updateGridSettings(User user, GridSetting settingsToSave);
    public Collection<GridSetting> loadGridSettings(User user);
}

