/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils;

/**
 * <p>Custom compound key</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:16 $
 */

public class CustomID
    implements java.io.Serializable, Comparable {

    // =============================================================== Fields

    private String entityName;
    private String langId;

    // =============================================================== Initialization

    public CustomID( String entityName, String langId ) {
        this.entityName = entityName;
        this.langId = langId;
    }

    // =============================================================== Inherited methods

    /*(non-Javadoc)
     * @see Comparable#compareTo()
     */
    public int compareTo( Object o ) {

        if( o == this ) {
            return 0;
        }

        CustomID c = ( CustomID ) o;
        if( entityName.equals( c.entityName ) ) {
            return langId.compareTo( c.langId );
        } else {
            return entityName.compareTo( c.entityName );
        }
    }

    /*(non-Javadoc)
     * @see Object#hashCode()
     */
    public int hashCode() {
        return entityName.hashCode() | ( langId.hashCode() << 37 );
    }

    /*(non-Javadoc)
     * @see Object#equals(Object)
     */
    public boolean equals( Object other ) {

        if( other == null || ! ( other instanceof CustomID ) ) {
            return false;
        }

        CustomID c = ( CustomID ) other;
        return entityName.equals( c.entityName ) && langId.equals( c.langId );
    }

    /*(non-Javadoc)
     * @see Object#toString()
     */
    public String toString() {
        return "entityName=" + entityName + ", langID=" + langId;
    }

    // =============================================================== Access methods

    public String getEntityName() {
        return entityName;
    }

    public String getLangId() {
        return langId;
    }
}
