/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Contains entity DB object meta data</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:16 $
 */

public class EntityDdobjectInfoVO
    implements java.io.Serializable {

    private String dbobjectName;

    private List fields = new ArrayList();
    private List pkeys = new ArrayList();
    private List fkeys = new ArrayList();

    /**
     * Constructor.
     * @param dbobjectName DB object name
     */
    public EntityDdobjectInfoVO( String dbobjectName ) {
        this.dbobjectName = dbobjectName;
    }

    /**
     * Add entity field VO.
     * @param efiVO EntityFieldInfoVO object.
     */
    public void addField( EntityFieldInfoVO efiVO ) {
        fields.add( efiVO );
    }

    /**
     * Add entity field in key list.
     * @param entityFieldName entity field name
     */
    public void addPkey( String entityFieldName ) {
        pkeys.add( entityFieldName );
    }

    /**
     * Add foreign key.
     * @param fk EntityDdobjectInfoVO.FK object
     */
    public void addFkey( FK fk ) {
        fkeys.add( fk );
    }

    //
    // Getters.
    //

    public String getDbobjectName() {
        return dbobjectName;
    }

    public int getFieldSize() {
        return fields.size();
    }

    public EntityFieldInfoVO getField( int i ) {
        return( EntityFieldInfoVO ) fields.get( i );
    }

    public int getPkeySize() {
        return pkeys.size();
    }

    public String getPkey( int i ) {
        return( String ) pkeys.get( i );
    }

    public int getFkeySize() {
        return fkeys.size();
    }

    public FK getFkey( int i ) {
        return( FK ) fkeys.get( i );
    }

    // Hash code.
    public int hashCode() {
        return dbobjectName.hashCode();
    }

    // Equals.
    public boolean equals( Object o ) {
        if( o == null || ! ( o instanceof EntityDdobjectInfoVO ) ) {
            return false;
        } else {
            return( ( EntityDdobjectInfoVO ) o ).dbobjectName.equals( dbobjectName );
        }
    }

    /**
     * <p>Foreign keys structure</p>
     * @author [ALB] Baranov Andrey
     * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:16 $
     */
    public static class FK
        implements java.io.Serializable {

        private String pkDbcolumnName;
        private String fkDbobjectName;
        private String fkDbcolumnName;

        public FK( String pkDbcolumnName, String fkDbobjectName, String fkDbcolumnName ) {
            this.pkDbcolumnName = pkDbcolumnName;
            this.fkDbobjectName = fkDbobjectName;
            this.fkDbcolumnName = fkDbcolumnName;
        }

        public String getPkDbcolumnName() {
            return pkDbcolumnName;
        }

        public String getFkDbobjectName() {
            return fkDbobjectName;
        }

        public String getFkDbcolumnName() {
            return fkDbcolumnName;
        }
    }
}