/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils;

import com.queplix.core.jxb.entityschema.Property;

/**
 * Defines the entity schema interface.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:16 $
 */
public interface EntitySchema
    extends java.io.Serializable {

    /**
     * Init schema
     * @param schemaName schema name
     * @param properties array of Property objects
     */
    void init( String schemaName, Property[] properties );

    /**
     * Get schema name attribute
     * @return string
     */
    String getSchemaName();

    /**
     * Get entity DB object information
     * @param dbobject entity dbobject name
     * @return DB object info structure
     */
    EntityDdobjectInfoVO getEntityDdobjectInfo( String dbobject );

    /**
     * Get ALL entity DB object informations
     * @return collection of DB object info structures
     */
    java.util.Collection getEntityDdobjectInfo();
}
