/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.modules.config.utils;

import java.util.Map;

/**
 * Default implementation of the grid settings interface
 *
 * @author Sergey Kozmin
 * @since 06.02.2007
 */
public class GridSettingDefImpl implements GridSetting {
    private String formID;
    private boolean counterOn;
    private int pageSize;
    private Map<String, Integer> columnWidths;

    public GridSettingDefImpl() {
    }


    public GridSettingDefImpl(String formID, boolean counterOn, int pageSize, Map<String, Integer> columnWidths) {
        this.formID = formID;
        this.counterOn = counterOn;
        this.pageSize = pageSize;
        this.columnWidths = columnWidths;
    }

    public void initialize(String formID, boolean counterOn, int pageSize, Map<String, Integer> columnWidths) {
        this.formID = formID;
        this.counterOn = counterOn;
        this.pageSize = pageSize;
        this.columnWidths = columnWidths;
    }

    public boolean isCounterOn() {
        return counterOn;
    }

    public int getPageSize() {
        return pageSize;
    }

    public Map<String, Integer> getColumnWidths() {
        return columnWidths;
    }

    public String getFormID() {
        return formID;
    }

    public void setCounterOn(boolean counterOn) {
        this.counterOn = counterOn;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setColumnWidths(Map<String, Integer> columnWidths) {
        this.columnWidths = columnWidths;
    }

    public void setFormID(String formID) {
        this.formID = formID;
    }
}
