/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils;

import com.queplix.core.integrator.security.User;
import com.queplix.core.utils.dao.InterfaceDAO;

import java.util.Map;

/**
 * User Property Config DAO.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:17 $1
 */

public interface UserPropertyConfigDAO
        extends InterfaceDAO {

    /**
     * Delete user property
     *
     * @param userPropertyID UserPropertyID compound key
     * @return number of updated records
     */
    int deleteUserProperty(UserPropertyID userPropertyID);

    /**
     * Delete user property
     *
     * @param user user
     * @param likeString like string, that will be included to sql query as <code>likeString%</code> 
     * @return number of updated records
     */
    int deleteUserPropertiesLike(User user, String likeString);

    /**
     * Create new user property
     *
     * @param userPropertyID UserPropertyID compound key
     * @param userProperty   user property string
     * @return number of updated records
     */
    int createUserProperty(UserPropertyID userPropertyID, String userProperty);

    /**
     * Update user property
     *
     * @param userPropertyID UserPropertyID compound key
     * @param userProperty   user property string
     * @return number of updated records
     */
    int updateUserProperty(UserPropertyID userPropertyID, String userProperty);

    /**
     * Load user property
     *
     * @param userPropertyID UserPropertyID compound key
     * @return string
     */
    String loadUserProperty(UserPropertyID userPropertyID);

    /**
     * Load map of user properties
     *
     * @param user User object
     * @return key - value pairs
     */
    Map<String, String> loadAllUserProperty(User user);

    /**
     * Load map of user properties
     *
     * @param user User object
     * @param propsLike like string, that will be included to sql query as <code>propsLike%</code>
     * @return key - value pairs
     */
    Map<String, String> loadUserPropertiesLike(User user, String propsLike);
}
