/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.modules.config.jxb.Caption;
import com.queplix.core.modules.config.jxb.Captions;
import com.queplix.core.modules.config.utils.CaptionConfigDAO;
import com.queplix.core.modules.config.utils.CaptionID;
import com.queplix.core.utils.dao.AbstractDAO;
import com.queplix.core.utils.sql.SqlWrapper;
import com.queplix.core.utils.sql.SqlWrapperFactory;

/**
 * Project-specific implementation of the CaptionConfigDAO
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:17 $
 */

public class CaptionConfigDAOImpl
    extends AbstractDAO implements CaptionConfigDAO {

    // --------------------------------------------------------------- Variables

    protected SqlWrapper sqlWrapper = SqlWrapperFactory.getSqlWrapper();

    // --------------------------------------------------------------- Overrided Methods

    /*
     * No javadoc
     * @see CaptionConfigDAO#clearCaptionsVO
     */
    public int clearCaptionsVO( Captions captions ) {
        Connection con = null;
        PreparedStatement ps = null;

        try {
            con = sqlWrapper.doConnection();
            ps = sqlWrapper.doPreparedStatement( con, DBRealmManager.getSql( "del_caption" ) );
            sqlWrapper.getStringParser().setObject( ps, 1, captions.getId() );
            sqlWrapper.getIntParser().setObject( ps, 2, captions.getType() );
            return sqlWrapper.executeUpdate( ps );

        } catch( SQLException ex ) {
            throw new GenericSystemException( "SQL exception: " + ex.getMessage(), ex );

        } finally {
            sqlWrapper.closeConnection( con, ps );
        }

    }

    /*
     * No javadoc
     * @see CaptionConfigDAO#storeCaptionsVO
     */
    public int storeCaptionsVO( Captions captions ) {

        Connection con = null;
        PreparedStatement ps = null;

        String id = captions.getId();
        Integer type = captions.getType();
        Caption caption = null;

        try {
            con = sqlWrapper.doConnection();
            ps = sqlWrapper.doPreparedStatement( con, DBRealmManager.getSql( "insert_caption" ) );

            int updated = 0;
            for( int i = 0; i < captions.getCaptionCount(); i++ ) {
                caption = captions.getCaption( i );

                sqlWrapper.getStringParser().setValue( ps, 1, id );
                sqlWrapper.getIntParser().setValue( ps, 2, type );
                sqlWrapper.getStringParser().setValue( ps, 3, caption.getLang().toString() );
                sqlWrapper.getStringParser().setValue( ps, 4, caption.getContent() );
                updated += sqlWrapper.executeUpdate( ps );
            }

            return updated;

        } catch( SQLException ex ) {
            String msg = ( caption == null ) ? "Cannot store captions #" + id :
                "Cannot store caption #" + id + " with language '" + caption.getLang() + "'. ";

            throw new GenericSystemException( msg + "SQL exception: " + ex.getMessage(), ex );

        } finally {
            sqlWrapper.closeConnection( con, ps );
        }
    }

    /*
     * No javadoc
     * @see CaptionConfigDAO#loadCaptionsVO
     */
    public Captions loadCaptionsVO( CaptionID captionID ) {

        Connection con = null;
        PreparedStatement ps = null;

        Captions captions = new Captions();
        captions.setId( captionID.getId() );
        captions.setType( captionID.getType() );

        try {
            con = sqlWrapper.doConnection();
            ps = sqlWrapper.doPreparedStatement( con, DBRealmManager.getSql( "select_caption" ) );
            sqlWrapper.getStringParser().setObject( ps, 1, captions.getId() );
            sqlWrapper.getIntParser().setObject( ps, 2, captions.getType() );
            ResultSet rs = sqlWrapper.executeQuery( ps );
            while( rs.next() ) {
                Caption caption = new Caption();
                caption.setLang(sqlWrapper.getStringParser().getValue( rs, 1 ));
                caption.setContent( sqlWrapper.getStringParser().getValue( rs, 2 ) );

                captions.addCaption( caption );
                captions.putObject( caption.getLang().toString(), caption );
            }

        } catch( SQLException ex ) {
            throw new GenericSystemException( "SQL exception: " + ex.getMessage(), ex );

        } finally {
            sqlWrapper.closeConnection( con, ps );
        }

        return captions;
    }
}
