/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils.db;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.modules.config.jxb.Caption;
import com.queplix.core.modules.config.jxb.Captions;
import com.queplix.core.modules.config.jxb.Custom;
import com.queplix.core.modules.config.jxb.CustomField;
import com.queplix.core.modules.config.utils.CaptionConstants;
import com.queplix.core.modules.config.utils.EntityHelper;
import com.queplix.core.utils.log.AbstractLogger;
import com.queplix.core.utils.log.Log;
import com.queplix.core.utils.sql.SqlWrapper;
import com.queplix.core.utils.sql.SqlWrapperFactory;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * Fast project-specific implementation of the CustomConfigDAO
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:17 $
 */

public class CustomConfigDAOImpl
    extends com.queplix.core.modules.config.utils.ejb.CustomConfigDAOImpl {

    // --------------------------------------------------------------- Variables

    protected SqlWrapper sqlWrapper = SqlWrapperFactory.getSqlWrapper();
    protected AbstractLogger logger = Log.getLog( CustomConfigDAOImpl.class );

    // --------------------------------------------------------------- Overrided Methods

    /*
     * No javadoc
     * @see CustomConfigDAO#CustomConfigDAO
     */
    // [MVT] Why do we need this method???
//    public int storeCustomsVO( Custom[] customs ) {
//
//        int updated = 0;
//        Connection con = null;
//        PreparedStatement delPs = null;
//        PreparedStatement insertPs = null;
//
//        try {
//            con = sqlWrapper.doConnection();
//            delPs = sqlWrapper.doPreparedStatement( con, DBRealmManager.getSql( "del_caption" ) );
//            insertPs = sqlWrapper.doPreparedStatement( con, DBRealmManager.getSql( "insert_caption" ) );
//
//            // Read Custom in cycle.
//            int size = customs.length;
//            for( int i = 0; i < size; i++ ) {
//                Custom custom = customs[i];
//
//                if( logger.getLogger().isInfoEnabled() ) {
//                    logger.INFO( i + "[" + size + "] Filling captions for entity '" +
//                                 custom.getEntity() + "'..." );
//                }
//
//                // Read CustomField in cycle.
//                for( int j = 0; j < custom.getCustomFieldCount(); j++ ) {
//                    CustomField customField = custom.getCustomField( j );
//                    String efieldId = EntityHelper.getFieldId( custom.getEntity(), customField.getEfield() );
//                    Captions captions = customField.getCaptions();
//
//                    // Remove captions.
//                    sqlWrapper.getStringParser().setObject( delPs, 1, efieldId );
//                    sqlWrapper.getIntParser().setObject( delPs, 2, CaptionConstants.LABEL_TYPE );
//                    sqlWrapper.executeUpdate( delPs );
//
//                    // Update captions (add statement to the batch).
//                    for( int k = 0; k < captions.getCaptionCount(); k++ ) {
//                        Caption caption = captions.getCaption( k );
//                        sqlWrapper.getStringParser().setValue( insertPs, 1, efieldId );
//                        sqlWrapper.getIntParser().setValue( insertPs, 2, CaptionConstants.LABEL_TYPE );
//                        sqlWrapper.getStringParser().setValue( insertPs, 3, caption.getLang().toString() );
//                        sqlWrapper.getStringParser().setValue( insertPs, 4, caption.getContent() );
//                        updated += sqlWrapper.executeUpdate( insertPs );
//                    }
//                }
//            }
//
//        } catch( SQLException ex ) {
//            throw new GenericSystemException( "SQL exception: " + ex.getMessage(), ex );
//
//        } finally {
//            sqlWrapper.closeConnection( insertPs );
//            sqlWrapper.closeConnection( con, delPs );
//        }
//
//        return updated;
//    }

}
