/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils.db;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.modules.config.error.NoSuchPropertyException;
import com.queplix.core.modules.config.utils.SysPropertyDAO;
import com.queplix.core.utils.dao.AbstractDAO;
import com.queplix.core.utils.sql.SqlWrapper;
import com.queplix.core.utils.sql.SqlWrapperFactory;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Project-specific implementation of the SysPropertyDAO
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:18 $
 */

public class SysPropertyDAOImpl
    extends AbstractDAO implements SysPropertyDAO {

    // --------------------------------------------------------------- Variables

    protected SqlWrapper sqlWrapper = SqlWrapperFactory.getSqlWrapper();

    // --------------------------------------------------------------- Overrided Methods

    /*
     * No javadoc
     * @see SysPropertyDAO#deleteProperty
     */
    public int deleteProperty( String propID ) {
        Connection con = null;
        PreparedStatement ps = null;

        try {
            con = sqlWrapper.doConnection();
            ps = sqlWrapper.doPreparedStatement( con, DBRealmManager.getSql( "delete_sys_prop" ) );
            ps.setString( 1, propID );

            return sqlWrapper.executeUpdate( ps );

        } catch( SQLException ex ) {
            throw new GenericSystemException( "SQL exception: " + ex.getMessage(), ex );

        } finally {
            sqlWrapper.closeConnection( con, ps );
        }
    }

    /*
     * No javadoc
     * @see SysPropertyDAO#createProperty
     */
    public int createProperty( String propID, String value ) {

        Connection con = null;
        PreparedStatement ps = null;

        try {
            con = sqlWrapper.doConnection();
            ps = sqlWrapper.doPreparedStatement( con, DBRealmManager.getSql( "insert_sys_prop" ) );
            ps.setString( 1, propID );
            ps.setString( 2, value );

            return sqlWrapper.executeUpdate( ps );

        } catch( SQLException ex ) {
            throw new GenericSystemException( "SQL exception: " + ex.getMessage(), ex );

        } finally {
            sqlWrapper.closeConnection( con, ps );
        }
    }

    /*
     * No javadoc
     * @see SysPropertyDAO#updateProperty
     */
    public int updateProperty( String propID, String value ) {

        Connection con = null;
        PreparedStatement ps = null;

        try {
            con = sqlWrapper.doConnection();
            ps = sqlWrapper.doPreparedStatement( con, DBRealmManager.getSql( "update_sys_prop" ) );
            ps.setString( 1, propID );
            ps.setString( 2, value );

            return sqlWrapper.executeUpdate( ps );

        } catch( SQLException ex ) {
            throw new GenericSystemException( "SQL exception: " + ex.getMessage(), ex );

        } finally {
            sqlWrapper.closeConnection( con, ps );
        }
    }

    /*
     * No javadoc
     * @see SysPropertyDAO#loadProperty
     */
    public String loadProperty( String propID )
        throws NoSuchPropertyException {

        Connection con = null;
        PreparedStatement ps = null;

        String sysProperty = null;

        try {
            con = sqlWrapper.doConnection();
            ps = sqlWrapper.doPreparedStatement( con, DBRealmManager.getSql( "select_sys_prop" ) );
            ps.setString( 1, propID );
            ResultSet rs = sqlWrapper.executeQuery( ps );
            if( !rs.next() ) {
                throw new NoSuchPropertyException( propID );
            }

            sysProperty = sqlWrapper.getStringParser().getValue( rs, 1 );

        } catch( SQLException ex ) {
            throw new GenericSystemException( "SQL exception: " + ex.getMessage(), ex );

        } finally {
            sqlWrapper.closeConnection( con, ps );
        }

        return sysProperty;
    }

}
