/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

import com.queplix.core.jxb.entity.Entity;

/**
 * <p>EQL entity request object</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:19 $
 */

public class EQLEReq
    extends EQLReq {

    // ------------------------------------------------------- variables

    private Entity entity;

    // ------------------------------------------------------- constructor

    public EQLEReq( Entity entity ) {
        this.entity = entity;
    }

    // ------------------------------------------------------- public methods

    // Get base entity.
    public Entity getEntity() {
        return entity;
    }

    // Hash code.
    public int hashCode() {
        return entity.hashCode();
    }

    // Equals.
    public boolean equals( Object o ) {
        if( o == null )
            return false;

        if( o == this )
            return true;

        if( o instanceof EQLEReq ) {
            EQLEReq eReq = ( EQLEReq ) o;
            return entity.getName().equals( eReq.getEntity().getName() );
        }

        return false;
    }

    // To string.
    public String toString() {
        return "entity request: " + entity.getName();
    }
}
