/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.jxb.entity.types.SqlSType;
import com.queplix.core.utils.StringHelper;

/**
 * <p>EQL Number object</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLNumberObject
    extends EQLObject
    implements java.io.Serializable {

    private Number value;

    public EQLNumberObject( Number value ) {
        this.value = value;
    }

    public Number getValue() {
        return value;
    }

    public Object getObject() {
        return value;
    }

    public int getSqlType() {
        if( value instanceof Long )
            return SqlSType.LONG_TYPE;
        else if( value instanceof Integer )
            return SqlSType.INT_TYPE;
        else if( value instanceof Float )
            return SqlSType.FLOAT_TYPE;
        else
            throw new GenericSystemException( "Can't get type for '" + value.getClass() + "'" );
    }

    public String toString() {
        if( value != null )
            return value.toString();
        else
            return StringHelper.EMPTY_VALUE;
    }

    public int hashCode() {
        return value.hashCode();
    }

    public boolean equals( Object o ) {
        if( o == null || ! ( o instanceof EQLNumberObject ) )
            return false;

        if( o == this )
            return true;

        EQLNumberObject obj = ( EQLNumberObject ) o;

        // Long and Integer values can be equal
        if( ( ( value instanceof Long ) || ( value instanceof Integer ) ) &&
            ( ( obj.value instanceof Long ) || ( obj.value instanceof Integer ) ) ) {
            return value.longValue() == obj.value.longValue();

        } else {
            return value.equals( obj.value );
        }
    }
}
