/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

import com.queplix.core.jxb.entity.Entity;

/**
 * <p>EQL Request Entity object</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLReqEntity
    implements java.io.Serializable {

    // base entity
    private Entity entity;
    // special attributes
    private EQLReqField masterReqField;

    public EQLReqEntity( Entity entity ) {
        this( entity, null );
    }

    public EQLReqEntity( Entity entity, EQLReqField masterReqField ) {
        this.entity = entity;
        this.masterReqField = masterReqField;
    }

    public Entity getEntity() {
        return entity;
    }

    public EQLReqField getMasterReqField() {
        return masterReqField;
    }

    public int hashCode() {
        return entity.hashCode() | ( masterReqField == null ? 0 : masterReqField.hashCode() );
    }

    public boolean equals( Object o ) {
        if( o == null )
            return false;

        if( o == this )
            return true;

        if( o instanceof EQLReqEntity ) {
            EQLReqEntity reqEntity = ( EQLReqEntity ) o;

            // don't consider master ReqField
            return entity.getName().equals( reqEntity.getEntity().getName() );
        }

        return false;
    }

    public String toString() {
        return "entity=" + entity.getName() + " masterReqField=" + masterReqField;
    }
}
