/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

import java.util.ArrayList;

/**
 * <p>EQL Request Order By Clause object</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLReqOrder
    implements java.io.Serializable {

    private ArrayList subOrders;
    private boolean hasMandatory;

    public EQLReqOrder() {
        this.subOrders = new ArrayList();
        this.hasMandatory = false;
    }

    public void addSubOrder( EQLReqSubOrder subOrder ) {
        subOrders.add( subOrder );
        if( subOrder.isMandatory() )
            hasMandatory = true;
    }

    public ArrayList getSubOrders() {
        return subOrders;
    }

    public EQLReqSubOrder getSubOrder( int i ) {
        return( EQLReqSubOrder ) subOrders.get( i );
    }

    public int size() {
        return subOrders.size();
    }

    public boolean hasMandatory() {
        return hasMandatory;
    }
}