/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocal;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocalHome;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.cache.CacheObjectManager;

/**
 * <p>EQL session</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.2 $ $Date: 2006/06/22 13:51:01 $
 */

public final class EQLSession
    implements java.io.Serializable {

    // ---------------------------------------------------- Fields

    // User logon session
    private LogonSession ls;
    private CacheObjectManager com = null;

    // ---------------------------------------------------- Public methods

    /**
     * Constructor
     */
    public EQLSession() {}

    /**
     * Set LogonSession object
     * @param ls LogonSession object
     */
    public void setLogonSession( LogonSession ls ) {
        this.ls = ls;
    }

    /**
     * Get LogonSession object
     * @return LogonSession object
     */
    public LogonSession getLogonSession() {
        return ls;
    }

    /**
     * Try to find Entity object by the name
     * @param name the Entity name attr
     * @return Entity object
     */
    public Entity findEntity( String name ) {
        EntityViewConfigManagerLocal local = ( EntityViewConfigManagerLocal )
            getCOM().getLocalObject( JNDINames.EntityViewConfigManager,
                                     EntityViewConfigManagerLocalHome.class );
        return local.getEntityViewConfig( name );
    }

    //
    // Get Cache Object Manager
    //
    public CacheObjectManager getCOM() {
        if (com == null) {
            com = new CacheObjectManager();
        }
        return com;
    }

}
