/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.aggs;

import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.jxb.entity.types.DataSType;
import com.queplix.core.jxb.entity.types.SqlSType;
import com.queplix.core.modules.config.utils.EntityHelper;

/**
 * <p>Count Aggregate Efield object</p>
 * <p>Special field with type Long for aggregate count function result</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:22 $
 */

public class CountAggEfield
    extends Efield {

    private static final String FIELD_NAME = "_count_";

    private CountAggEfield() {}

    public static Efield newInstance( Entity entity ) {

        Efield field = new Efield();
        field.setName( FIELD_NAME );
        field.setEntityName( entity.getName() );
        field.setId( EntityHelper.getFieldId( entity.getName(), FIELD_NAME ) );
        field.setSqltype( SqlSType.LONG );
        field.setDatatype( DataSType.LONG );
        field.setSelectable( Boolean.TRUE );
        field.setVirtual( Boolean.TRUE );

        return field;
    }
}
