/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.ejb;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.EQLERes;
import com.queplix.core.modules.eql.EQLResRecord;
import com.queplix.core.modules.eql.error.EQLException;

import javax.ejb.EJBLocalObject;

/**
 * Locking operations manager local interface.
 * @author [SVM] Maxim Suponya
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:25 $
 */
public interface LockManagerLocal
    extends EJBLocalObject {

    void check( EQLERes eqlRes, LogonSession ls )
        throws EQLException;

    void lock( EQLERes eqlRes, String focusId, Long focusInstance, LogonSession ls )
        throws EQLException;

    void unlock( EQLERes eqlRes, LogonSession ls )
        throws EQLException;

    void unlock( EQLERes eqlRes, LogonSession ls, EQLResRecord record )
        throws EQLException;

    void unlock( LogonSession ls );

    void ping( EQLERes eqlRes, LogonSession ls );
}
