/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.ejb;

import com.queplix.core.utils.ejb.AbstractSessionEJB;
import com.queplix.core.utils.sql.SqlWrapper;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * Next key generator.
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:25 $
 */

public class NextKeyEJB
    extends AbstractSessionEJB {

    // --------------------------------------------------------------- public methods

    public void ejbCreate() {}

    /**
     * Get next unique key
     * @param table table name
     * @return new unique key
     */
    public long next( String table ) {

        SqlWrapper sqlW = getSqlWrapper();
        Connection con = null;
        try {
            con = sqlW.doConnection();
            return sqlW.getNextKey( con, table );

        } catch( SQLException ex ) {
            throwException( "SQL exception: " + ex.getMessage(), ex );
            return -1;

        } finally {
            sqlW.closeConnection( con );
        }
    }
}
