/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.funcs;

import com.queplix.core.modules.config.utils.SysPropertyManager;
import com.queplix.core.modules.eql.EQLObject;
import com.queplix.core.modules.eql.EQLReqFuncExecutable;
import com.queplix.core.modules.eql.EQLReqOp;
import com.queplix.core.modules.eql.EQLReqSubOpMember;
import com.queplix.core.modules.eql.EQLReqSubOpMemberFunc;
import com.queplix.core.modules.eql.EQLStringObject;
import com.queplix.core.modules.eql.error.EQLFunctionParseException;

/**
 * <p>User Parameter Function Implementation</p>
 * @author Sergei Gurov
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:25 $
 */
public final class SystemPropertyFunc
    extends EQLReqSubOpMemberFunc implements EQLReqFuncExecutable {

    // process
    public EQLReqSubOpMember execute() {

        EQLReqOp reqOp = getParameter( 0 );
        if( reqOp == null ) {
            throw new EQLFunctionParseException( this );
        }

        String paramName;
        try {
            EQLStringObject subOpMember = ( EQLStringObject ) reqOp.getSubOp( 0 ).getMember();
            paramName = subOpMember.getValue();
        } catch( Exception ex ) {
            throw new EQLFunctionParseException( this, ex );
        }

        Object paramValue = SysPropertyManager.getProperty( paramName );
        return EQLObject.getInstance( paramValue );
    }
}
