/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.parser;

import com.queplix.core.modules.eql.EQLDReq;
import com.queplix.core.modules.eql.EQLDRes;
import com.queplix.core.modules.eql.EQLEReq;
import com.queplix.core.modules.eql.EQLERes;
import com.queplix.core.modules.eql.EQLReq;
import com.queplix.core.modules.eql.EQLRes;
import com.queplix.core.modules.eql.EQLResMetaData;
import com.queplix.core.modules.eql.EQLSql;
import com.queplix.core.modules.eql.error.EQLException;

/**
 * <p>SQL executor abstract class</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:27 $
 */

public abstract class SQLExecutor
    extends SQLEQLPluggableModule {

    /**
     * EQL select query
     * @param req EQL request object
     * @param eqlSql EQLSql object
     * @return EQLRes EQL response object
     * @throws EQLException
     */
    public abstract EQLRes doSelect( EQLReq req, EQLSql eqlSql )
        throws EQLException;

    /**
     * Calculate number of rows in <code>eqlSql</code> query
     * and return number of records in database
     * @param eqlSql EQLSql query object
     * @return number of records in EQL query
     * @throws EQLException
     */
    public abstract int doCount( EQLSql eqlSql )
        throws EQLException;

    /**
     * EQL update/insert/delete query
     * @param res EQL response object
     * @param eqlSql EQLSql object
     * @return number of updated records
     * @throws EQLException
     */
    public abstract int doUpdate( EQLERes res, EQLSql eqlSql )
        throws EQLException;

    // ----------------------------------------------------- STATIC METHODS

    //
    // Initialize new response
    //
    protected final static EQLRes newEQLRes( EQLReq req, EQLSql eqlSql ) {

        EQLRes res = null;

        if( req instanceof EQLDReq ) {
            res = new EQLDRes( ( ( EQLDReq ) req ).getReqDataset() );

        } else if( req instanceof EQLEReq ) {
            res = new EQLERes( ( ( EQLEReq ) req ).getEntity() );

        } else {
            res = new EQLRes();
        }

        EQLResMetaData resMetaData = new EQLResMetaData();
        resMetaData.setReq( req );
        resMetaData.setEQLSql( eqlSql );
        res.setMetaData( resMetaData );

        return res;
    }
}
