/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.parser.mysql;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.types.SqlSType;
import com.queplix.core.modules.eql.EQLReq;
import com.queplix.core.modules.eql.EQLReqMetaData;
import com.queplix.core.modules.eql.EQLReqSelectAttr;
import com.queplix.core.modules.eql.EQLStringObject;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.funcs.FTSFunc;
import com.queplix.core.modules.eql.funcs.IsNullFunc;
import com.queplix.core.modules.eql.funcs.DateDiffFunc;
import com.queplix.core.modules.eql.parser.generic.SQLExecutorGenericImpl;
import com.queplix.core.modules.eql.parser.generic.SQLSelectBuilderGenericImpl;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;


/**
 * <p>Select SQL builder mysql implementation</p>
 *
 * @author Sergey Savchuk
 */
public class SQLSelectBuilderMysqlImpl extends SQLSelectBuilderGenericImpl {


    protected String end() throws EQLException {
        StringBuffer sql = new StringBuffer(super.end());

        // add LIMIT clause that constrain the number of rows returned by the SELECT statement
        Integer page = SQLExecutorGenericImpl.getPage( req );
        Integer pageSize = SQLExecutorGenericImpl.getPageSize( req );
        if( page != null && pageSize != null ) {
            // always retrive one record more to detect "has next" flag
            long requestLength = ( page.intValue() + 1 ) * pageSize.intValue() + 1;
            if( requestLength > 0 ) {
                sql.append("\nLIMIT ");
                sql.append(requestLength);
            }
        }

        return sql.toString();
    }


    /*
     * (No javadoc)
     * @see SQLSelectBuilderGenericImpl#getSQLColumnSelect
     */
    protected String getSQLColumnSelect( EQLReq req, EQLReqSelectAttr reqSelectAttr )
        throws EQLException {

        Efield field = reqSelectAttr.getReqField().getField();
        int sql_type = field.getSqltype().getType();
        boolean isLazy = req.isLazy( field );

        if( sql_type == SqlSType.MEMO_LONG_TYPE ) {
            return super.getSQLColumnSelect( req, reqSelectAttr );
        } else {
            if( isLazy ) {
                if( !field.getVirtual().booleanValue() ) {
                    // Use CASE expression for none-virtual fields
                    String sqlColumnName = getSQLOperand( reqSelectAttr.getReqOp() );
                    return "(CASE WHEN " + sqlColumnName + " IS NULL THEN 0 ELSE 1 END)";
                } else {
                    // Field is vitual - always return '1'
                    return "1";
                }
            }
        }

        // Return default column
        return super.getSQLColumnSelect( req, reqSelectAttr );
    }

    /*
    * (No javadoc)
    * @see SQLBuilder#getCountSql
    */
    protected String getCountSql(String mainSql) throws EQLException {

        try {
            // remove <LIMIT> clause
            RE re = new RE("\\slimit[\\s\t\n\r]+\\d", RE.MATCH_CASEINDEPENDENT);
            if (re.match(mainSql)) {
                mainSql = mainSql.substring(0, re.getParenStart(0)) +
                        mainSql.substring(re.getParenEnd(0));
            }
        } catch (RESyntaxException ex) {
            throw new GenericSystemException(ex);
        }
        return super.getCountSql(mainSql);
    }

    protected String getSQLOperandMember(FTSFunc memberField) throws EQLException {
        // @todo write appropriate implementation
        return null;
    }
    
    protected String getSQLOperandMember( IsNullFunc memberField )
        throws EQLException {

        return "ifnull(" + getSQLOperand( memberField.getParameter( 0 ) ) + "," + getSQLOperand( memberField.getParameter( 1 ) ) + ")";
    }

    protected String getSQLOperandMember( DateDiffFunc memberField )
        throws EQLException {

        return "datediff(" + getSQLOperand( memberField.getParameter( 1 ) ) + "," + getSQLOperand( memberField.getParameter( 0 ) ) + ")";
    }
    
}
