/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.update.impl;

import com.queplix.core.modules.eql.EQLResCell;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;

import java.util.StringTokenizer;

/**
 * Error sending configuration check.
 *
 * @author [SVS] Sorokin Sergey
 * @version 1.0
 */
public class ErrorCfgUpdate
    extends EntityUpdate {

    public int beforeUpdate()
        throws EQLException {

        EQLResCell emailsCell = getCell( "emails" );
        EQLResCell employeeCell = getCell( "employee_id" );
        EQLResCell workgroupCell = getCell( "workgroup_id" );

        if( ( emailsCell.isNull() ) && ( employeeCell.isNull() ) && ( workgroupCell.isNull() ) ) {
            throw new EQLException( "'Employee', 'Workgroup' or 'E-Mails' has to be filled in." );
        }

        EQLResCell target_maskCell = getCell( "target_class_mask" );
        if( !isValidClassMask( target_maskCell.getString() ) ) {
            throw new EQLException( "Target Class Mask is not valid." );
        }

        EQLResCell msg_handlerCell = getCell( "message_hnd_class" );
        if( !isValidClass( msg_handlerCell.getString() ) ) {
            throw new EQLException( "Message Handler is not valid." );
        }

        return CONTINUE;
    }

    private boolean isValidClassMask( String mask ) {
        if( mask == null ) {
            return false;
        }
        if( mask.length() == 0 ) {
            return false;
        }
        if( mask.lastIndexOf( '*' ) != mask.length() - 1 ) {
            return false;
        }
        if( mask.equals( "*" ) ) {
            return true;
        }
        StringTokenizer t = new StringTokenizer( mask, "." );
        int i = 0;
        while( t.hasMoreTokens() ) {
            String s = t.nextToken( "." );
            if( mask.equals( "*" ) ) {
                if( t.hasMoreTokens() ) {
                    return false;
                } else {
                    return true;
                }
            }
            if( i == 0 ) {
                if( !s.equals( "com" ) ) {
                    return false;
                }
            }
            if( i == 1 ) {
                if( !s.equals( "queplix" ) ) {
                    return false;
                }
            }
            if( s.indexOf( " ,:()\"`~!@#$%^&+-" ) >= 0 ) {
                return false;
            }
            i++;
        }
        return true;
    }

    private boolean isValidClass( String className ) {
        try {
            Class c = Class.forName( className );
        } catch( Exception e ) {
            return false;
        }
        return true;
    }

} // end of class
