/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.ejb;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.CompoundKey;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eqlext.GetRecordsRes;
import com.queplix.core.modules.eqlext.jxb.gr.ExtReqs;
import com.queplix.core.modules.eqlext.jxb.gr.Reqs;

import javax.ejb.EJBLocalObject;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Properties;

/**
 * GetRecords EJB local interface.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:38 $
 */
public interface GetRecordsLocal
    extends EJBLocalObject {

    // Base process.
    // =============

    GetRecordsRes process( Reqs reqs, LogonSession ls )
        throws EQLException;

    GetRecordsRes process( String entityName,
                           CompoundKey compoundPkey,
                           Properties prop,
                           LogonSession ls )
        throws EQLException;

    GetRecordsRes process( String entityName,
                           CompoundKey[] compoundPkeys,
                           Properties prop,
                           LogonSession ls )
        throws EQLException;

    GetRecordsRes process( String entityName,
                           String pkeyEntityName,
                           CompoundKey[] compoundPkeys,
                           Properties prop,
                           LogonSession sc )
        throws EQLException;

    void process( String entityName,
                  String pkeyEntityName,
                  CompoundKey[] compoundPkeys,
                  Properties prop,
                  PrintWriter out,
                  LogonSession ls )
        throws EQLException;

    void process( Reqs reqs, PrintWriter out, LogonSession sc )
        throws EQLException;

    void process( Reader in, PrintWriter out, LogonSession sc )
        throws EQLException;

    // Extended process.
    // =================

    void extProcess( ExtReqs extReqs, PrintWriter out, LogonSession sc )
        throws EQLException;

    void extProcess( Reader in, PrintWriter out, LogonSession sc )
        throws EQLException;

}
