/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.ejb;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eqlext.jxb.gr.Report;
import com.queplix.core.modules.eqlext.utils.ReportCallbackHnd;

import javax.ejb.EJBLocalObject;
import javax.mail.MessagingException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;

/**
 * Report manager EJB local interface.
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.2 $ $Date: 2006/08/24 16:21:58 $
 */

public interface ReportManagerLocal
    extends EJBLocalObject {
    // NRA code: method to send report in specified format
    void sendFormattedReportByMail( long reportSchedulerId , String reportFormat)
    throws EQLException, MessagingException;
    // end
    void sendReportByMail( long reportSchedulerId )
        throws EQLException, MessagingException;

    void sendReportByMail( long reportSchedulerId, String transletName )
        throws EQLException, MessagingException;

    void printReport( LogonSession ls,
                      Report report,
                      String transletName,
                      Writer pw,
                      ReportCallbackHnd hnd )
        throws EQLException;

    void printReport( LogonSession ls,
                      Report report,
                      String transletName,
                      Map transletParams,
                      Writer pw,
                      ReportCallbackHnd hnd )
        throws EQLException;

    void printReport( LogonSession ls,
                      Report report,
                      String transletName,
                      Map transletParams,
                      OutputStream os,
                      ReportCallbackHnd hnd )
        throws EQLException;
}
