/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.transforms;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.eqlext.error.EfieldTransformException;
import com.queplix.core.utils.log.AbstractLogger;

/**
 * Field value converter from string to Java object.
 * 
 * <p>
 * <b>Note</b> The implementatin subclasses must be thread safe!
 * </p>
 * 
 * @author [ALB] Baranov L. Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:39 $
 */
public abstract class EfieldTransform extends AbstractLogger {

    /**
     * Transforms string to Java object.
     * 
     * @param ls user logon sesson
     * @param entity Entity object
     * @param field Efield object
     * @param s string value
     * @return java object
     * 
     * @throws EfieldTransformException for invalid strings
     */
    abstract public Object toObject(LogonSession ls, Entity entity, Efield field, String s) throws EfieldTransformException;

    /**
     * Transforms Java object to string.
     * 
     * @param ls user logon sesson
     * @param entity Entity object
     * @param field Efield object
     * @param o object
     * @return string representation of object
     * 
     * @throws EfieldTransformException for invalid objects
     */
    abstract public String toString(LogonSession ls, Entity entity, Efield field, Object o) throws EfieldTransformException;

}