/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.utils.images;

/**
 * <p>Keeps attachment structure</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:42 $
 */

public class Attachment
    implements java.io.Serializable {

    private String name;
    private String subfolder;
    private String content;

    // Constructor.
    public Attachment( String name, String subfolder, String content ) {

        if( name == null ) {
            throw new NullPointerException( "Name is NULL" );
        }
        if( subfolder == null ) {
            throw new NullPointerException( "Subfolder is NULL" );
        }

        this.name = name;
        this.subfolder = subfolder;
        this.content = content;
    }

    // Getters.
    public String getName() {
        return name;
    }

    public String getSubfolder() {
        return subfolder;
    }

    public String getContent() {
        return content;
    }

    // Setters.
    public void setName( String name ) {
        this.name = name;
    }

    public void setSubfolder( String subfolder ) {
        this.subfolder = subfolder;
    }

    public void setContent( String content ) {
        this.content = content;
    }

    // Special.

    public int hashCode() {
        return name.hashCode() | ( subfolder.hashCode() << 37 );
    }

    public boolean equals( Object o ) {
        if( o == null || ! ( o instanceof Attachment ) ) {
            return false;
        }

        Attachment a = ( Attachment ) o;
        return a.name.equals( name ) && a.subfolder.equals( subfolder );
    }

    public String toString() {
        return "name=" + name + "; subfolder=" + subfolder + "; content=" + content;
    }
}
