/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.inbox.utils;

import com.queplix.core.modules.inbox.Account;
import com.queplix.core.modules.inbox.utils.log.SystemLogPublisher;
import com.queplix.core.utils.log.AbstractLogger;

/**
 * <p>Inbox pluggable module abstract class</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1 $ $Date: 2006/01/20 15:19:10 $
 */

public abstract class AbstractInboxPluggableModule
    extends AbstractLogger implements InboxPluggableModule {

    // ----------------------------------------------------- variables

    protected Account account;
    protected SystemLogPublisher publisher;
    protected String logName;

    // ----------------------------------------------------- setters/getters

    /*
     * No javadoc
     * @see InboxPluggableModule#setAccount
     */
    public final void setAccount( Account account ) {
        this.account = account;
    }

    /*
     * No javadoc
     * @see InboxPluggableModule#getAccount
     */
    public final Account getAccount() {
        return account;
    }

    /*
     * No javadoc
     * @see InboxPluggableModule#setLogPublisher
     */
    public final void setLogPublisher( SystemLogPublisher publisher ) {
        this.publisher = publisher;
    }

    /*
     * No javadoc
     * @see InboxPluggableModule#getLogPublisher
     */
    public final SystemLogPublisher getLogPublisher() {
        return publisher;
    }

    /*
     * No javadoc
     * @see InboxPluggableModule#setLogName
     */
    public final void setLogName( String logName ) {
        this.logName = logName;
    }

    /*
     * No javadoc
     * @see InboxPluggableModule#getLogName
     */
    public final String getLogName() {
        return logName;
    }
}
