/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.inbox.utils;

import javax.mail.Message;
import javax.mail.MessagingException;

/**
 * IMAP4 Inbox Provider.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1 $ $Date: 2006/01/20 15:19:10 $
 */

public class IMAPInboxProvider
    extends AbstractInboxProvider {

    // ----------------------------------------------------- getters

    /*
     * No javadoc
     * @see InboxProvider#getJavaMailProto
     */
    public String getJavaMailProto() {
        return "imap";
    }

    /*
     * No javadoc
     * @see InboxProvider#getUID
     */
    public String getUID( Message message )
        throws MessagingException {

        if( folder instanceof com.sun.mail.imap.IMAPFolder ) {
            com.sun.mail.imap.IMAPFolder pf = ( com.sun.mail.imap.IMAPFolder ) folder;
            return "" + pf.getUID( message );
        } else {
            return null;
        }
    }

    /*
     * No javadoc
     * @see InboxProvider#getMessage
     */
    public Message getMessage( String uid )
        throws MessagingException {

        long l;
        try {
            l = Long.parseLong( uid );
        } catch( NumberFormatException ex ) {
            ERROR( ex );
            return null;
        }

        if( folder instanceof com.sun.mail.imap.IMAPFolder ) {
            com.sun.mail.imap.IMAPFolder pf = ( com.sun.mail.imap.IMAPFolder ) folder;
            return pf.getMessageByUID( l );
        } else {
            return null;
        }
    }

}
