/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.modules.inbox.utils;

import com.queplix.core.modules.inbox.InboxMessage;

/**
 * Description.
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public interface MailFilter extends InboxPluggableModule {

    /**
     * Mail filtering function.
     * <p>
     * Returns: <br>
     *  <b>true</b>  - to SEND the message to a next filter in the filters chain,
     *  <b>false</b> - to FINISH the message prosessing
     * </p>
     *
     * @param message InboxMessage
     * @return true or false
     */
    boolean filterMail(InboxMessage message);

} // end of interface
