/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.inbox.utils;

import javax.mail.Message;
import javax.mail.MessagingException;

/**
 * Filters inbox messages.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1 $ $Date: 2006/01/20 15:19:10 $
 */

public interface MessageFilter
    extends java.io.Serializable {

    /**
     * Filter message.
     * @param message Message
     * @return true if Message is ok
     * @throws MessagingException
     */
    boolean filter( Message message )
        throws MessagingException;

    /**
     * Returns last info message if filtering operation failed.
     * @return String
     */
    String getInfo();
}
