/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.inbox.utils;

import javax.mail.Message;
import javax.mail.MessagingException;

/**
 * Inbox Message Filter default implementation.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1 $ $Date: 2006/01/20 15:19:10 $
 */

public class SingleMessageFilter
    implements MessageFilter {

    private String uid;
    private InboxProvider provider;

    /**
     * Constructor.
     * @param uid message UID
     * @param provider some inbox provider
     */
    public SingleMessageFilter( String uid, InboxProvider provider ) {
        this.uid = uid;
        this.provider = provider;
    }

    /*
     * No javadoc.
     * @see MessageFilter#filter
     */
    public boolean filter( Message message )
        throws MessagingException {

        String _uid = provider.getUID( message );
        if( _uid == null ) {
            return false;
        } else {
            return _uid.equals( uid );
        }
    }

    /*
     * No javadoc.
     * @see MessageFilter#getInfo
     */
    public String getInfo() {
        return "No info available";
    }
}
