/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.inbox.utils.log;

import com.queplix.core.modules.inbox.InboxMessage;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.services.utils.log.Level;

/**
 * Outbox LOG record value object.
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.1 $ $Date: 2006/01/20 15:19:10 $
 */

public class OutboxLogRecord
    extends AbstractInboxLogRecord {

    public static final int CLASS_ID = 2;

    // ------------------------------------------------------- Constructor

    public OutboxLogRecord( LogonSession ls,
                            Level level,
                            String message,
                            long process_id,
                            InboxMessage im ) {

        super( ls, level, message, process_id, im );
    }

    // ------------------------------------------------------- Public overrided methods

    /*
     * No javadoc
     * @see BaseLogRecord#getClassId
     */
    public int getClassID() {
        return CLASS_ID;
    }
}
