/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;

import java.util.List;

/**
 * <p>History table field handler</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:47 $
 */
public class HistoryTableFieldObjectHandler
    extends JEObjectHandler {

    public String getEntityName() {
        return "his_tblfield";
    }

    public Class getObjectClass() {
        return HistoryTableFieldObject.class;
    }

    /**
     * Select by PKEY
     * @param local JEOManager local interface
     * @param ls user logon session
     * @param hisFieldId history field ID
     * @return JEObjectHandler object
     * @throws EQLException
     */
    public static JEObjectHandler selectByPkey( JEOManagerLocal local,
                                                LogonSession ls,
                                                long hisFieldId )
        throws EQLException {

        String eql = "SELECT his_tblfield.* WHERE his_tblfield.his_field_id = " + hisFieldId;

        List hndList = local.select( ls, HistoryTableFieldObjectHandler.class, eql );
        if( hndList == null ) {
            return null;
        } else {
            return( JEObjectHandler ) hndList.get( 0 );
        }
    }

    /**
     * Select by table name
     * @param local JEOManager local interface
     * @param ls user logon session
     * @param dbObject entity dbObject attribute
     * @return collection of JEObjectHandler objects
     * @throws EQLException
     */
    public static List selectByTableName( JEOManagerLocal local,
                                          LogonSession ls,
                                          String dbObject )
        throws EQLException {

        // Ignore case!
        String eql = "SELECT his_tblfield.* WHERE LOWER(his_tblfield.his_table_name) = " +
                     "LOWER('" + dbObject + "')";

        return local.select( ls, HistoryTableFieldObjectHandler.class, eql );
    }
}
