/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;

import java.util.List;

/**
 * Permission JEO handler.
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @author [MVT] Michael Trofimov
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:48 $
 */
public class PermissionObjectHandler
    extends JEObjectHandler {

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */
    public String getEntityName() {
        return "permission";
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return PermissionObject.class;
    }

    // ============================================================= EQL methods

    /**
     * Gets the permission by its ID.
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param permissionID permission ID to search by
     * @return permission JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler selectByID( JEOManagerLocal manager,
                                              LogonSession ls,
                                              long permissionID )
        throws EQLException {

        String eql = "select /* pageSize=1 */ permission.* where permission.permission_id = " + permissionID;

        List hndList = manager.select( ls, PermissionObjectHandler.class, eql );
        return( hndList != null ) ? ( JEObjectHandler ) hndList.get( 0 ) : null;
    }

    /**
     * Gets the permission by security role ID.
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param roleID security role ID to search by
     * @return permission JEO handlers list, or <code>null</code> if none found
     * @throws EQLException
     */
    public static List selectByRoleID( JEOManagerLocal manager,
                                       LogonSession ls,
                                       long roleID )
        throws EQLException {

        String eql = "select permission.* where permission.role_id = " + roleID;

        return manager.select( ls, PermissionObjectHandler.class, eql );
    }

}
