/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;

import java.util.List;

/**
 * <p>Script request JEO handler.</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:48 $
 */
public class ScriptObjectHandler
    extends JEObjectHandler {

    public String getEntityName() {
        return "scripts";
    }

    public Class getObjectClass() {
        return ScriptObject.class;
    }

    public static JEObjectHandler selectByPkey( JEOManagerLocal local, LogonSession ls, int pkey )
        throws EQLException {

        String eql = "SELECT scripts.* WHERE scripts.script_id = " + pkey;

        List hndList = local.select( ls, ScriptObjectHandler.class, eql );
        if( hndList == null )
            return null;
        else
            return( JEObjectHandler ) hndList.get( 0 );
    }

    public static JEObjectHandler selectByName( JEOManagerLocal local, LogonSession ls, String name )
        throws EQLException {

        String eql = "SELECT scripts.* WHERE scripts.script_name = '" + name + "'";

        List hndList = local.select( ls, ScriptObjectHandler.class, eql );
        if( hndList == null )
            return null;
        else
            return( JEObjectHandler ) hndList.get( 0 );
    }

    public static List selectAll( JEOManagerLocal local, LogonSession ls )
        throws EQLException {
        return local.select( ls, ScriptObjectHandler.class, "SELECT scripts.*" );
    }

}
